USE [ProSolutionReports]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [vOG_2526_Enrolment]
AS

----------------------------------------------------
--Enrolment Import Template for OneGrade VA
----------------------------------------------------

SELECT
T.AcademicYearID,
T.LearnerRef,
T.LearningAimRef,
T.CourseCode,
T.CompletionStatusID,
Enr.Grade,
T.StartDate,
Enr.ExpectedEndDate,
Enr.ActualEndDate,
LTRIM(RTRIM(CollegeLevels.Level2Code)) + ' - ' + LEFT(CollegeLevels.Level2Name,200) AS UDFS1, --College Level Code and Name - alter to Level 1, 2, 3, 4 as desired
NULL AS UDFS2,
NULL AS UDFS3, NULL AS UDFS4, 
NULL AS UDFNum, NULL AS UDFDate,
NULL AS UDFS5, NULL AS UDFS6, 
NULL AS UDFS7, NULL AS UDFS8, 
NULL AS UDFNum2,
/* choose one or other of the next two lines depending on whether Offering Groups are used*/
[Off].Code + ' - ' + ISNULL(OG.Code, '') AS TeachingGroupCode, -- with offering groups, or
--[Off].Code AS TeachingGroupCode, -- no offering groups
/* choose one or other of the next two lines depending on whether Offering Groups are used*/
[Off].[Name] + ' - ' + ISNULL(OG.Code, '') AS TeachingGroupName, -- with offering groups, or
--[Off].[Name] AS TeachingGroupName, -- no offering groups
Enr.OutcomeID

FROM
	(
			--This will return the key enrolment records and avoid duplicates
			SELECT DISTINCT
				Min(E.EnrolmentID) AS MinEnrolmentID,	
				SD.AcademicYearID,			--*UniqueKey
				SD.RefNo AS LearnerRef,		--*UniqueKey
				O.QualID AS LearningAimRef,	--*UniqueKey
				C.CourseCode,				--*UniqueKey
				E.CompletionStatusID,		--*UniqueKey
				E.StartDate					--*UniqueKey

			FROM         
				ProSolution.dbo.Enrolment AS E WITH (NOLOCK) 
				INNER JOIN ProSolution.dbo.Offering AS O WITH (NOLOCK)
					 ON E.OfferingID = O.OfferingID
						INNER JOIN ProSolution.dbo.Learning_Aim AS LA WITH (NOLOCK)
						ON O.QualID = LA.LEARNING_AIM_REF
							INNER JOIN ProSolution.dbo.StudentDetail AS SD WITH (NOLOCK)
							ON E.StudentDetailID = SD.StudentDetailID
								INNER JOIN vOG_CourseCode AS C WITH (NOLOCK)
								ON O.OfferingID = C.OfferingID

			WHERE     
				SD.AcademicYearID = '25/26'
				AND E.CompletionStatusID NOT IN ('X') --cancelled
				--AND LA.NOTIONAL_NVQ_LEVEL_CODE IN ('2','3') --L2, L3
				--AND O.OfferingTypeID IN (8, 17) --FE Programme, Apprenticeship component : alter as required
				--AND O.QualID NOT LIKE 'Z%' --Don't include Z code Learning Aims
			
			GROUP BY 
				SD.AcademicYearID, SD.RefNo, O.QualID, C.CourseCode, E.CompletionStatusID, E.StartDate
	) T

--ensure that we join on T.MinEnrolmentID
INNER JOIN ProSolution.dbo.Enrolment AS Enr WITH (NOLOCK)
ON T.MinEnrolmentID = Enr.EnrolmentID
	INNER JOIN ProSolution.dbo.Offering AS [Off] WITH (NOLOCK)
	ON Enr.OfferingID = [Off].OfferingID
		LEFT JOIN ProSolution.dbo.OfferingGroup AS OG WITH (NOLOCK)
		ON [Off].OfferingID = OG.OfferingID 
		AND Enr.OfferingGroupID = OG.OfferingGroupID

	LEFT JOIN --College Structure
	(
		--Level1
		SELECT
			CL1.[SID], CL1.Code AS Level1Code, '' AS Level2Code, '' AS Level3Code, '' AS Level4Code, CL1.[Name] AS Level1Name, '' AS Level2Name, '' AS Level3Name, '' AS Level4Name
		FROM 
			ProSolution.dbo.CollegeLevel CL1 WITH (NOLOCK)
			RIGHT JOIN ProSolution.dbo.AcademicYear AcYr WITH (NOLOCK) 
			ON ISNULL(CL1.MaxAcademicYearID, '25/26') = AcYr.AcademicYearID
		WHERE
			CL1.[Enabled] = 1 AND LevelNum = 1
		
		UNION
		--level2
		SELECT 
			CL2.[SID], CL1.Code AS Level1Code, CL2.Code AS Level2Code, '' AS Level3Code, '' AS Level4Code, CL1.[Name] AS Level1Name, CL2.[Name] AS Level2Name, '' AS Level3Name, '' AS Level4Name
		FROM
		(
		SELECT
			CL.[SID], CL.Code, CL.[Name], CL.LevelNum, CL.ParentSID, CL.ParentLevelNum
		FROM 
			ProSolution.dbo.CollegeLevel CL WITH (NOLOCK)
			RIGHT JOIN ProSolution.dbo.AcademicYear AcYr WITH (NOLOCK) 
			ON ISNULL(CL.MaxAcademicYearID, '25/26') = AcYr.AcademicYearID
		WHERE
			CL.[Enabled] = 1 AND LevelNum = 2
		) CL2
			INNER JOIN
			(
			SELECT
				CL.SID, CL.Code, CL.[Name], CL.LevelNum, CL.ParentSID, CL.ParentLevelNum
			FROM 
				ProSolution.dbo.CollegeLevel CL WITH (NOLOCK)
				RIGHT JOIN ProSolution.dbo.AcademicYear AcYr WITH (NOLOCK) 
				ON ISNULL(CL.MaxAcademicYearID, '25/26') = AcYr.AcademicYearID
			WHERE
				CL.[Enabled] = 1 AND LevelNum = 1
			) CL1

			ON CL2.ParentSID  = CL1.[SID] AND CL2.ParentLevelNum = CL1.LevelNum

		UNION
		--Level3
		SELECT
			CL3.[SID], CL2.Level1Code, CL2.Level2Code, CL3.Code AS Level3Code, '' AS Level4Code, CL2.Level1Name AS Level1Name, CL2.Level2Name AS Level2Name, CL3.[Name] AS Level3Name, '' AS Level4Name
		FROM
		(
			SELECT
				CL2.[SID], CL1.Code AS Level1Code, CL2.Code AS Level2Code, CL2.LevelNum, CL1.[Name] AS Level1Name, CL2.[Name] AS Level2Name
			FROM
				(
				SELECT
					CL.[SID], CL.Code, CL.[Name], CL.LevelNum, CL.ParentSID, CL.ParentLevelNum
				FROM 
					ProSolution.dbo.CollegeLevel CL WITH (NOLOCK)
					RIGHT JOIN ProSolution.dbo.AcademicYear AcYr WITH (NOLOCK) 
					ON ISNULL(CL.MaxAcademicYearID, '25/26') = AcYr.AcademicYearID
				WHERE
					CL.[Enabled] = 1 AND LevelNum = 2
				) CL2
			
				INNER JOIN
				(
				SELECT
					CL.[SID], CL.Code, CL.[Name], CL.LevelNum, CL.ParentSID, CL.ParentLevelNum
				FROM 
					ProSolution.dbo.CollegeLevel CL WITH (NOLOCK)
					RIGHT JOIN ProSolution.dbo.AcademicYear AcYr WITH (NOLOCK) 
					ON ISNULL(CL.MaxAcademicYearID, '25/26') = AcYr.AcademicYearID
				WHERE
					CL.[Enabled] = 1 AND LevelNum = 1
				) CL1
			ON CL2.ParentSID  = CL1.[SID] AND CL2.ParentLevelNum = CL1.LevelNum
		) CL2

		INNER JOIN
		(
		SELECT
			CL.[SID], CL.Code, CL.[Name], CL.LevelNum, CL.ParentSID, CL.ParentLevelNum
		FROM 
			ProSolution.dbo.CollegeLevel CL WITH (NOLOCK)
			RIGHT JOIN ProSolution.dbo.AcademicYear AcYr WITH (NOLOCK) 
			ON ISNULL(CL.MaxAcademicYearID, '25/26') = AcYr.AcademicYearID
		WHERE
			CL.[Enabled] = 1 AND LevelNum = 3
		) CL3

		ON CL3.ParentSID = CL2.[SID] AND CL3.ParentLevelNum = CL2.LevelNum

		UNION
		--Level4
		SELECT
			CL4.[SID], CL3.Level1Code, CL3.Level2Code, CL3.Level3Code, CL4.Code AS Level4Code, CL3.Level1Name AS Level1Name, CL3.Level2Name AS Level2Name, CL3.[Name] AS Level3Name, CL4.[Name] AS Level4Name
		FROM
		(
			SELECT
				CL3.[SID], CL2.Level1Code, CL2.Level2Code, CL3.Code AS Level3Code, CL3.LevelNum, CL2.Level1Name, CL2.Level2Name, CL3.[Name]
			FROM
			(
				SELECT
					CL2.[SID], CL1.Code AS Level1Code, CL2.Code AS Level2Code, CL2.LevelNum, CL1.[Name] AS Level1Name, CL2.[Name] AS Level2Name
				FROM
				(
				SELECT
					CL.[SID], CL.Code, CL.[Name], CL.LevelNum, CL.ParentSID, CL.ParentLevelNum
				FROM 
					ProSolution.dbo.CollegeLevel CL WITH (NOLOCK)
					RIGHT JOIN ProSolution.dbo.AcademicYear AcYr WITH (NOLOCK) 
					ON ISNULL(CL.MaxAcademicYearID, '25/26') = AcYr.AcademicYearID
				WHERE
					CL.[Enabled] = 1 AND LevelNum = 2
				) CL2
				
				INNER JOIN
				(
				SELECT
					CL.[SID], CL.Code, CL.[Name], CL.LevelNum, CL.ParentSID, CL.ParentLevelNum
				FROM 
					ProSolution.dbo.CollegeLevel CL WITH (NOLOCK)
					RIGHT JOIN ProSolution.dbo.AcademicYear AcYr WITH (NOLOCK) 
					ON ISNULL(CL.MaxAcademicYearID, '25/26') = AcYr.AcademicYearID
				WHERE
					CL.[Enabled] = 1 AND LevelNum = 1
				) CL1
			
				ON CL2.ParentSID  = CL1.[SID] AND CL2.ParentLevelNum = CL1.LevelNum
		
			) CL2

			INNER JOIN
			(
			SELECT
				CL.[SID], CL.Code, CL.[Name], CL.LevelNum, CL.ParentSID, CL.ParentLevelNum
			FROM 
				ProSolution.dbo.CollegeLevel CL WITH (NOLOCK)
				RIGHT JOIN ProSolution.dbo.AcademicYear AcYr WITH (NOLOCK) 
				on ISNULL(CL.MaxAcademicYearID, '25/26') = AcYr.AcademicYearID
			WHERE
				CL.[Enabled] = 1 AND LevelNum = 3
			) CL3

			ON CL3.ParentSID = CL2.[SID] AND CL3.ParentLevelNum = CL2.LevelNum

		) CL3

		INNER JOIN
		(
		SELECT
			CL.[SID], CL.Code, CL.[Name], CL.LevelNum, CL.ParentSID, CL.ParentLevelNum
		FROM 
			ProSolution.dbo.CollegeLevel CL WITH (NOLOCK)
			RIGHT JOIN ProSolution.dbo.AcademicYear AcYr WITH (NOLOCK) 
			ON ISNULL(CL.MaxAcademicYearID, '25/26') = AcYr.AcademicYearID
		WHERE
			CL.[Enabled] = 1 AND LevelNum = 4
		) CL4

		ON CL4.ParentSID = CL3.[SID] AND CL4.ParentLevelNum = CL3.LevelNum

	) CollegeLevels
	
	ON [Off].[SID] = CollegeLevels.[SID]
	
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
